package gov.va.genisis2.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Data Transfer Object (DTO) to transfer request history related details
 * 
 * @author Prasad Thummalapalli
 *
 */
// @JsonIgnoreProperties({ "request" })
public class RequestHistoryDTO implements Serializable {

	private static final long serialVersionUID = -1210120649546242675L;

	private int histLineNo;
	private int requestId;
	private int processId;
	private String title;
	private String description;
	private String statusDescription;
	private int requestTypeId;
	private int sourceId;
	private int studyApprovalId;
	private Date createdOn;
	private Date modifiedOn;
	private String createdBy;
	private String modifiedBy;
	private String approverId;
	private String taskId;
	//TODO: rename commentHistory - commentHistories
	private List<CommentHistoryDTO> commentHistory;
	
	/**
	 * @return the histLineNo
	 */
	public int getHistLineNo() {
		return histLineNo;
	}

	/**
	 * @param histLineNo
	 *            the histLineNo to set
	 */
	public void setHistLineNo(int histLineNo) {
		this.histLineNo = histLineNo;
	}

	/**
	 * @return the requestId
	 */
	public int getRequestId() {
		return requestId;
	}

	/**
	 * @param requestId
	 *            the requestId to set
	 */
	public void setRequestId(int requestId) {
		this.requestId = requestId;
	}

	/**
	 * @return the processId
	 */
	public int getProcessId() {
		return processId;
	}

	/**
	 * @param processId
	 *            the processId to set
	 */
	public void setProcessId(int processId) {
		this.processId = processId;
	}

	/**
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @param title
	 *            the title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the statusDescription
	 */
	public String getStatusDescription() {
		return statusDescription;
	}

	/**
	 * @param statusDescription
	 *            the statusDescription to set
	 */
	public void setStatusDescription(String statusDescription) {
		this.statusDescription = statusDescription;
	}

	/**
	 * @return the requestTypeId
	 */
	public int getRequestTypeId() {
		return requestTypeId;
	}

	/**
	 * @param requestTypeId
	 *            the requestTypeId to set
	 */
	public void setRequestTypeId(int requestTypeId) {
		this.requestTypeId = requestTypeId;
	}

	/**
	 * @return the sourceId
	 */
	public int getSourceId() {
		return sourceId;
	}

	/**
	 * @param sourceId
	 *            the sourceId to set
	 */
	public void setSourceId(int sourceId) {
		this.sourceId = sourceId;
	}

	/**
	 * @return the studyApprovalId
	 */
	public int getStudyApprovalId() {
		return studyApprovalId;
	}

	/**
	 * @param studyApprovalId
	 *            the studyApprovalId to set
	 */
	public void setStudyApprovalId(int studyApprovalId) {
		this.studyApprovalId = studyApprovalId;
	}

	/**
	 * @return the createdOn
	 */
	public Date getCreatedOn() {
		return createdOn;
	}

	/**
	 * @param createdOn
	 *            the createdOn to set
	 */
	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * @return the modifiedOn
	 */
	public Date getModifiedOn() {
		return modifiedOn;
	}

	/**
	 * @param modifiedOn
	 *            the modifiedOn to set
	 */
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	/**
	 * @return the createdBy
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * @param createdBy
	 *            the createdBy to set
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * @return the modifiedBy
	 */
	public String getModifiedBy() {
		return modifiedBy;
	}

	/**
	 * @param modifiedBy
	 *            the modifiedBy to set
	 */
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	/**
	 * @return the approverId
	 */
	public String getApproverId() {
		return approverId;
	}

	/**
	 * @param approverId
	 *            the approverId to set
	 */
	public void setApproverId(String approverId) {
		this.approverId = approverId;
	}

	/**
	 * @return the taskId
	 */
	public String getTaskId() {
		return taskId;
	}

	/**
	 * @param taskId
	 *            the taskId to set
	 */
	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}
	
	public List<CommentHistoryDTO> getCommentHistory() {
		return commentHistory;
	}
	
	public void setCommentHistory(List<CommentHistoryDTO> commentHistory) {
		this.commentHistory = commentHistory;
	}
}
